

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 py-12">
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <div class="flex items-center justify-between email-accounts-header">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Email Accounts</h1>
                    <p class="mt-2 text-gray-600">Manage your connected email accounts</p>
                </div>
                <div class="flex space-x-3 email-accounts-actions">
                    <!-- Google OAuth Button -->
                    <a href="<?php echo e(route('oauth.google.start')); ?>" 
                       class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Add Gmail (OAuth)
                    </a>
                    
                    <!-- SMTP+IMAP Button - Simple Link -->
                    <a href="<?php echo e(route('smtp-imap.setup')); ?>" 
                       class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-green-600 hover:bg-green-700">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        Add SMTP+IMAP Account
                    </a>
                    
                    <!-- Back to Inbox -->
                    <a href="<?php echo e(route('email.index')); ?>" 
                       class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                        ← Back to Inbox
                    </a>
                </div>
            </div>
        </div>

        <!-- Success/Error Messages -->
        <?php if(session('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <!-- Email Accounts List -->
        <?php if($mailAccounts->count() > 0): ?>
            <div class="grid gap-6">
                <?php $__currentLoopData = $mailAccounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white shadow-sm rounded-lg border border-gray-200 p-6">
                        <div class="flex items-center justify-between">
                            <div class="flex-1">
                                <div class="flex items-center space-x-3 mb-3">
                                    <div class="flex items-center">
                                        <svg class="w-6 h-6 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                        </svg>
                                        <div>
                                            <h3 class="text-lg font-medium text-gray-900"><?php echo e($account->email); ?></h3>
                                        </div>
                                    </div>
                                    
                                    <!-- Status Badges -->
                                    <div class="flex space-x-2">
                                        <?php if($account->is_primary): ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                Primary
                                            </span>
                                        <?php endif; ?>
                                        
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                            <?php echo e($account->connection_type === 'oauth' ? 'bg-blue-100 text-blue-800' : 'bg-orange-100 text-orange-800'); ?>">
                                            <?php echo e(ucfirst($account->connection_type ?? 'oauth')); ?>

                                        </span>
                                    </div>
                                </div>
                                
                                <div class="text-sm text-gray-600 space-y-1">
                                    <div><strong>From Name:</strong> <?php echo e($account->from_name ?? 'Not set'); ?></div>
                                    <?php if($account->connection_type === 'smtp'): ?>
                                        <div><strong>SMTP Host:</strong> <?php echo e($account->smtp_host); ?></div>
                                        <div><strong>SMTP Port:</strong> <?php echo e($account->smtp_port); ?> (<?php echo e(strtoupper($account->smtp_encryption)); ?>)</div>
                                        <div><strong>IMAP Status:</strong> 
                                            <?php if($account->hasImapConfig()): ?>
                                                <span class="text-green-600">✅ Configured</span>
                                            <?php else: ?>
                                                <span class="text-orange-600">⚠️ Not configured</span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <div><strong>Connected:</strong> <?php echo e($account->created_at->format('M j, Y g:i A')); ?></div>
                                </div>
                            </div>
                            
                            <!-- Action Buttons -->
                            <div class="flex items-center space-x-3">
                                <?php if(!$account->is_primary): ?>
                                    <form method="POST" action="<?php echo e(route('email.set-primary', $account)); ?>" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" 
                                                class="inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                            Set Primary
                                        </button>
                                    </form>
                                <?php endif; ?>
                                
                                <?php if($account->connection_type === 'smtp' && !$account->hasImapConfig()): ?>
                                    <form method="POST" action="<?php echo e(route('email.add-imap', $account)); ?>" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" 
                                                class="inline-flex items-center px-3 py-2 border border-green-300 shadow-sm text-sm font-medium rounded-md text-green-700 bg-white hover:bg-green-50 focus:outline-none focus:ring-2 focus:ring-green-500"
                                                onclick="return confirm('This will add IMAP settings to enable email fetching. Continue?')">
                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path>
                                            </svg>
                                            Add IMAP
                                        </button>
                                    </form>
                                <?php endif; ?>
                                
                                <a href="<?php echo e(route('email.signatures', $account)); ?>" 
                                   class="inline-flex items-center px-3 py-2 border border-purple-300 shadow-sm text-sm font-medium rounded-md text-purple-700 bg-white hover:bg-purple-50 focus:outline-none focus:ring-2 focus:ring-purple-500">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.232 5.232l3.536 3.536m-2.036-5.036a2.5 2.5 0 113.536 3.536L6.5 21.036H3v-3.572L16.732 3.732z"></path>
                                    </svg>
                                    Signatures
                                </a>
                                
                                <form method="POST" action="<?php echo e(route('email.delete-account', $account)); ?>" style="display: inline;" 
                                      onsubmit="return confirm('Are you sure you want to delete this email account? This action cannot be undone.')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" 
                                            class="inline-flex items-center px-3 py-2 border border-red-300 shadow-sm text-sm font-medium rounded-md text-red-700 bg-white hover:bg-red-50 focus:outline-none focus:ring-2 focus:ring-red-500">
                                        Delete Account
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <!-- Empty State -->
            <div class="text-center py-12">
                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                </svg>
                <h3 class="mt-2 text-sm font-medium text-gray-900">No email accounts</h3>
                <p class="mt-1 text-sm text-gray-500">Get started by connecting an email account.</p>
                <div class="mt-6 email-accounts-empty-actions">
                    <a href="<?php echo e(route('oauth.google.start')); ?>" 
                       class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700">
                        Connect Gmail Account
                    </a>
                    <span class="mx-2 text-gray-500">or</span>
                    <a href="<?php echo e(route('smtp-imap.setup')); ?>" 
                       class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        Add SMTP Account
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\iyall\OneDrive\Documents\AI\claude\replypilot\resources\views/email/accounts.blade.php ENDPATH**/ ?>