<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'ReplyPilot')); ?> - Dashboard</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        a:hover { text-decoration: none !important; }
        a { text-decoration: none !important; }
        ul, ol, li { list-style: none !important; list-style-type: none !important; }
        li::before, li::marker { content: none !important; display: none !important; }
    </style>
</head>
<body class="font-sans antialiased bg-gray-100">
    <div class="min-h-screen">
        <!-- Navigation -->
        <nav class="bg-white shadow">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        <h1 class="text-lg sm:text-xl font-semibold text-gray-900">ReplyPilot</h1>
                    </div>

                    <!-- Mobile menu button -->
                    <div class="flex items-center md:hidden">
                        <button type="button" onclick="toggleMobileMenu()" class="inline-flex items-center justify-center p-2 rounded-md text-gray-700 hover:text-gray-900 hover:bg-gray-100">
                            <svg id="menu-icon" class="block h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                            <svg id="close-icon" class="hidden h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>

                    <!-- Desktop navigation -->
                    <div class="hidden md:flex md:items-center md:space-x-4">
                        <a href="<?php echo e(\App\Helpers\RoleBasedNavigation::getReviewsIndexRoute()); ?>" class="text-gray-700 hover:text-gray-900 text-sm">Reviews</a>
                        <a href="<?php echo e(\App\Helpers\RoleBasedNavigation::getEmailIndexRoute()); ?>" class="text-gray-700 hover:text-gray-900 text-sm">Inbox</a>
                        <form method="POST" action="<?php echo e(route('logout')); ?>" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="text-gray-700 hover:text-gray-900 text-sm">Logout</button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Mobile menu -->
            <div id="mobile-menu" class="hidden md:hidden">
                <div class="px-2 pt-2 pb-3 space-y-1 bg-gray-50 border-t">
                    <a href="<?php echo e(\App\Helpers\RoleBasedNavigation::getReviewsIndexRoute()); ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Reviews</a>
                    <a href="<?php echo e(\App\Helpers\RoleBasedNavigation::getEmailIndexRoute()); ?>" class="block px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Inbox</a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="block">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full text-left px-3 py-2 rounded-md text-base font-medium text-gray-700 hover:bg-gray-100">Logout</button>
                    </form>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
            <?php if(session('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="px-4 py-6 sm:px-0">
                <div class="text-center">
                    <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-4">Welcome to ReplyPilot</h2>
                    <p class="text-base sm:text-lg text-gray-600 mb-8">Your AI-powered reply assistant for Google Business Profile reviews and Gmail</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Google Connection Card -->
                    <div class="bg-white overflow-hidden shadow rounded-lg">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Google Account</h3>
                            <?php
                                $googleConfig = config('services.google');
                                $isConfigured = !empty($googleConfig['client_id']) && !empty($googleConfig['client_secret']);
                            ?>
                            
                            <?php if($isConfigured): ?>
                                <p class="text-sm text-gray-600 mb-4">Connect your Google account to access Gmail and Google Business Profile.</p>
                                <a href="<?php echo e(route('oauth.google.start')); ?>" 
                                   class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700">
                                    Connect Google Account
                                </a>
                            <?php else: ?>
                                <div class="bg-yellow-50 border border-yellow-200 rounded-md p-4">
                                    <div class="flex">
                                        <div class="flex-shrink-0">
                                            <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                        <div class="ml-3">
                                            <h3 class="text-sm font-medium text-yellow-800">Google OAuth Not Configured</h3>
                                            <div class="mt-2 text-sm text-yellow-700">
                                                <p>To connect your Google account, you need to:</p>
                                                <ol class="list-decimal list-inside mt-2 space-y-1">
                                                    <li>Add your Google OAuth credentials to the .env file</li>
                                                    <li>Set up Google Cloud Console with proper APIs</li>
                                                </ol>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Quick Actions Card -->
                    <div class="bg-white overflow-hidden shadow rounded-lg">
                        <div class="px-4 py-5 sm:p-6">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Quick Actions</h3>
                            <div class="space-y-3">
                                <a href="<?php echo e(route('reviews.index')); ?>" 
                                   class="block w-full text-left px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">
                                    Manage Reviews
                                </a>
                                <a href="<?php echo e(route('email.index')); ?>" 
                                   class="block w-full text-left px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">
                                    Check Inbox
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Getting Started -->
                <div class="mt-8 bg-white overflow-hidden shadow rounded-lg">
                    <div class="px-4 py-5 sm:p-6">
                        <h3 class="text-lg font-medium text-gray-900 mb-4">Getting Started</h3>
                        <div class="space-y-4">
                            <div class="flex items-start">
                                <div class="flex-shrink-0">
                                    <div class="flex items-center justify-center h-8 w-8 rounded-full bg-indigo-100">
                                        <span class="text-indigo-600 font-semibold">1</span>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <h4 class="text-sm font-medium text-gray-900">Connect Google Account</h4>
                                    <p class="text-sm text-gray-600">Link your Google account to access Gmail and Google Business Profile.</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div class="flex-shrink-0">
                                    <div class="flex items-center justify-center h-8 w-8 rounded-full bg-indigo-100">
                                        <span class="text-indigo-600 font-semibold">2</span>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <h4 class="text-sm font-medium text-gray-900">Add Business Locations</h4>
                                    <p class="text-sm text-gray-600">Add your Google Business Profile locations to start managing reviews.</p>
                                </div>
                            </div>
                            <div class="flex items-start">
                                <div class="flex-shrink-0">
                                    <div class="flex items-center justify-center h-8 w-8 rounded-full bg-indigo-100">
                                        <span class="text-indigo-600 font-semibold">3</span>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <h4 class="text-sm font-medium text-gray-900">Start Managing</h4>
                                    <p class="text-sm text-gray-600">Fetch reviews and emails, generate AI drafts, and approve responses.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Mobile menu toggle
        function toggleMobileMenu() {
            const menu = document.getElementById('mobile-menu');
            const menuIcon = document.getElementById('menu-icon');
            const closeIcon = document.getElementById('close-icon');

            menu.classList.toggle('hidden');
            menuIcon.classList.toggle('hidden');
            menuIcon.classList.toggle('block');
            closeIcon.classList.toggle('hidden');
            closeIcon.classList.toggle('block');
        }
    </script>
</body>
</html>
<?php /**PATH C:\Users\iyall\OneDrive\Documents\AI\claude\replypilot\resources\views/dashboard.blade.php ENDPATH**/ ?>