<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

// Email cleanup scheduled task - runs daily at 2:00 AM
Schedule::command('email:cleanup-old')
    ->dailyAt('02:00')
    ->name('email-cleanup-daily')
    ->description('Clean up old ingested emails')
    ->withoutOverlapping();

// Automatic email ingestion - runs every minute (checks tenant settings internally)
// Reference: AUTO_INGESTION.md Section 4.5
// NOTE: Runs every minute but commands check tenant-specific intervals before executing
Schedule::command('emails:ingest-all')
    ->everyMinute()
    ->name('email-auto-ingest')
    ->description('Automatically ingest emails from all accounts based on tenant settings')
    ->withoutOverlapping()
    ->appendOutputTo(storage_path('logs/email-ingestion.log'));

// Automatic review ingestion - runs every minute (checks tenant settings internally)
// Reference: AUTO_INGESTION.md Section 4.5
// NOTE: Runs every minute but commands check tenant-specific intervals before executing
Schedule::command('reviews:ingest-all')
    ->everyMinute()
    ->name('reviews-auto-ingest')
    ->description('Automatically ingest reviews from all business profiles based on tenant settings')
    ->withoutOverlapping()
    ->appendOutputTo(storage_path('logs/review-ingestion.log'));

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');
