<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ReplyPilot - AI-Powered Email & Review Management</title>
    <meta name="description" content="The only platform that manages both emails AND reviews with AI. Save 2+ hours daily, work with any email provider, and respond to customers professionally.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Custom CSS for animations and effects -->
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap');
        
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .floating {
            animation: floating 3s ease-in-out infinite;
        }
        
        @keyframes floating {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        .pulse-glow {
            animation: pulse-glow 2s ease-in-out infinite;
        }
        
        @keyframes pulse-glow {
            0%, 100% { box-shadow: 0 0 20px rgba(102, 126, 234, 0.3); }
            50% { box-shadow: 0 0 30px rgba(102, 126, 234, 0.6); }
        }
        
        .slide-in {
            animation: slideIn 0.8s ease-out;
        }
        
        @keyframes slideIn {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .feature-card {
            transition: all 0.3s ease;
        }
        
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        }
        
        .coming-soon {
            position: relative;
            overflow: hidden;
        }
        
        .coming-soon::after {
            content: "COMING SOON";
            position: absolute;
            top: 10px;
            right: -30px;
            background: linear-gradient(45deg, #ff6b6b, #ff8e8e);
            color: white;
            padding: 5px 40px;
            font-size: 12px;
            font-weight: bold;
            transform: rotate(45deg);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Hero Section -->
    <section class="gradient-bg min-h-screen flex items-center">
        <div class="container mx-auto px-4 py-20">
            <div class="max-w-6xl mx-auto">
                <div class="grid lg:grid-cols-2 gap-12 items-center">
                    <!-- Left Column - Content -->
                    <div class="text-white slide-in">
                        <div class="mb-6">
                            <span class="bg-white bg-opacity-20 px-4 py-2 rounded-full text-sm font-semibold">
                                🚀 The Future of Customer Communication
                            </span>
                        </div>
                        
                        <h1 class="text-5xl lg:text-6xl font-bold mb-6 leading-tight">
                            The Only AI Platform That Manages
                            <span class="text-yellow-300">Both Emails & Reviews</span>
                        </h1>
                        
                        <p class="text-xl mb-8 text-gray-200 leading-relaxed">
                            Save 2+ hours daily with AI-generated responses. Works with ANY email provider. 
                            Real Google Business Profile integration. Multi-tenant ready for agencies.
                        </p>
                        
                        <div class="flex flex-col sm:flex-row gap-4 mb-8">
                            <a href="{{ route('login') }}" class="bg-yellow-400 hover:bg-yellow-500 text-gray-900 px-8 py-4 rounded-lg font-bold text-lg transition-all duration-300 transform hover:scale-105 pulse-glow">
                                Start Free Trial
                            </a>
                            <a href="#demo" class="border-2 border-white text-white hover:bg-white hover:text-gray-900 px-8 py-4 rounded-lg font-bold text-lg transition-all duration-300">
                                Watch Demo
                            </a>
                        </div>
                        
                        <div class="flex items-center space-x-8 text-sm">
                            <div class="flex items-center">
                                <span class="text-green-400 mr-2">✓</span>
                                <span>14-Day Free Trial</span>
                            </div>
                            <div class="flex items-center">
                                <span class="text-green-400 mr-2">✓</span>
                                <span>No Credit Card Required</span>
                            </div>
                            <div class="flex items-center">
                                <span class="text-green-400 mr-2">✓</span>
                                <span>Setup in 5 Minutes</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Right Column - Visual -->
                    <div class="relative">
                        <div class="floating">
                            <div class="bg-white rounded-2xl shadow-2xl p-8 transform rotate-3">
                                <div class="text-center mb-6">
                                    <div class="w-16 h-16 bg-gradient-to-r from-blue-500 to-purple-600 rounded-full mx-auto mb-4 flex items-center justify-center">
                                        <span class="text-white text-2xl font-bold">RP</span>
                                    </div>
                                    <h3 class="text-2xl font-bold text-gray-800">ReplyPilot Dashboard</h3>
                                </div>
                                
                                <div class="space-y-4">
                                    <div class="bg-gray-50 p-4 rounded-lg">
                                        <div class="flex items-center justify-between">
                                            <span class="text-sm font-medium text-gray-600">📧 Email Responses</span>
                                            <span class="text-green-600 font-bold">24/7 Active</span>
                                        </div>
                                    </div>
                                    
                                    <div class="bg-gray-50 p-4 rounded-lg">
                                        <div class="flex items-center justify-between">
                                            <span class="text-sm font-medium text-gray-600">⭐ Review Management</span>
                                            <span class="text-blue-600 font-bold">Auto-Sync</span>
                                        </div>
                                    </div>
                                    
                                    <div class="bg-gray-50 p-4 rounded-lg">
                                        <div class="flex items-center justify-between">
                                            <span class="text-sm font-medium text-gray-600">🤖 AI Provider</span>
                                            <span class="text-purple-600 font-bold">Multi-AI</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Floating Elements -->
                        <div class="absolute -top-4 -left-4 w-8 h-8 bg-yellow-400 rounded-full floating" style="animation-delay: 0.5s;"></div>
                        <div class="absolute -bottom-4 -right-4 w-6 h-6 bg-green-400 rounded-full floating" style="animation-delay: 1s;"></div>
                        <div class="absolute top-1/2 -right-8 w-4 h-4 bg-pink-400 rounded-full floating" style="animation-delay: 1.5s;"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="grid md:grid-cols-4 gap-8 text-center">
                    <div class="slide-in">
                        <div class="text-4xl font-bold gradient-text mb-2">89%</div>
                        <div class="text-gray-600 font-medium">Cost Reduction</div>
                        <div class="text-sm text-gray-500">Average savings per month</div>
                    </div>
                    <div class="slide-in" style="animation-delay: 0.2s;">
                        <div class="text-4xl font-bold gradient-text mb-2">2+</div>
                        <div class="text-gray-600 font-medium">Hours Saved Daily</div>
                        <div class="text-sm text-gray-500">Per user on average</div>
                    </div>
                    <div class="slide-in" style="animation-delay: 0.4s;">
                        <div class="text-4xl font-bold gradient-text mb-2">500+</div>
                        <div class="text-gray-600 font-medium">Businesses</div>
                        <div class="text-sm text-gray-500">Trust ReplyPilot</div>
                    </div>
                    <div class="slide-in" style="animation-delay: 0.6s;">
                        <div class="text-4xl font-bold gradient-text mb-2">99%</div>
                        <div class="text-gray-600 font-medium">Satisfaction</div>
                        <div class="text-sm text-gray-500">Customer rating</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-800 mb-4">
                        Why ReplyPilot is <span class="gradient-text">Different</span>
                    </h2>
                    <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                        The only platform that truly unifies email and review management with AI, 
                        while being affordable and easy to use for businesses of all sizes.
                    </p>
                </div>
                
                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <!-- Feature 1 -->
                    <div class="feature-card bg-white rounded-xl p-8 shadow-lg">
                        <div class="w-16 h-16 bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mb-6">
                            <span class="text-white text-2xl">📧</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Universal Email Integration</h3>
                        <p class="text-gray-600 mb-4">
                            Works with ANY email provider - Gmail, Outlook, Hostinger, cPanel, and more. 
                            No vendor lock-in, use your existing email accounts.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Gmail OAuth integration</li>
                            <li>• SMTP support for all providers</li>
                            <li>• IMAP email fetching</li>
                            <li>• Unified inbox experience</li>
                        </ul>
                    </div>
                    
                    <!-- Feature 2 -->
                    <div class="feature-card bg-white rounded-xl p-8 shadow-lg">
                        <div class="w-16 h-16 bg-gradient-to-r from-green-500 to-green-600 rounded-xl flex items-center justify-center mb-6">
                            <span class="text-white text-2xl">⭐</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Real Google Business Profile</h3>
                        <p class="text-gray-600 mb-4">
                            Direct integration with Google Business Profile API. 
                            Fetch real reviews, respond directly, and manage multiple locations.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Real-time review fetching</li>
                            <li>• Direct response posting</li>
                            <li>• Multi-location support</li>
                            <li>• Performance tracking</li>
                        </ul>
                    </div>
                    
                    <!-- Feature 3 -->
                    <div class="feature-card bg-white rounded-xl p-8 shadow-lg">
                        <div class="w-16 h-16 bg-gradient-to-r from-purple-500 to-purple-600 rounded-xl flex items-center justify-center mb-6">
                            <span class="text-white text-2xl">🤖</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Multi-AI Support</h3>
                        <p class="text-gray-600 mb-4">
                            Choose your preferred AI provider - ChatGPT, Gemini, or Anthropic. 
                            Switch between them or use multiple for different use cases.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• ChatGPT integration</li>
                            <li>• Google Gemini support</li>
                            <li>• Anthropic Claude access</li>
                            <li>• Easy provider switching</li>
                        </ul>
                    </div>
                    
                    <!-- Feature 4 -->
                    <div class="feature-card bg-white rounded-xl p-8 shadow-lg">
                        <div class="w-16 h-16 bg-gradient-to-r from-orange-500 to-orange-600 rounded-xl flex items-center justify-center mb-6">
                            <span class="text-white text-2xl">🏢</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Multi-Tenant Architecture</h3>
                        <p class="text-gray-600 mb-4">
                            Perfect for agencies managing multiple clients. 
                            Complete data isolation, role-based access, and white-label ready.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Complete data isolation</li>
                            <li>• Role-based permissions</li>
                            <li>• White-label branding</li>
                            <li>• Scalable infrastructure</li>
                        </ul>
                    </div>
                    
                    <!-- Feature 5 -->
                    <div class="feature-card bg-white rounded-xl p-8 shadow-lg">
                        <div class="w-16 h-16 bg-gradient-to-r from-red-500 to-red-600 rounded-xl flex items-center justify-center mb-6">
                            <span class="text-white text-2xl">⚡</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Lightning Fast Setup</h3>
                        <p class="text-gray-600 mb-4">
                            Get up and running in 5 minutes. No complex configurations, 
                            no technical expertise required. Just connect and go.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• 5-minute setup process</li>
                            <li>• No technical knowledge needed</li>
                            <li>• Automatic configuration</li>
                            <li>• Instant AI responses</li>
                        </ul>
                    </div>
                    
                    <!-- Feature 6 - Coming Soon -->
                    <div class="feature-card bg-white rounded-xl p-8 shadow-lg coming-soon">
                        <div class="w-16 h-16 bg-gradient-to-r from-pink-500 to-pink-600 rounded-xl flex items-center justify-center mb-6">
                            <span class="text-white text-2xl">📱</span>
                        </div>
                        <h3 class="text-xl font-bold text-gray-800 mb-4">Facebook Integration</h3>
                        <p class="text-gray-600 mb-4">
                            Coming soon! Manage Facebook messages, comments, and reviews 
                            alongside your emails and Google reviews.
                        </p>
                        <ul class="text-sm text-gray-500 space-y-1">
                            <li>• Facebook Messenger integration</li>
                            <li>• Comment management</li>
                            <li>• Review response system</li>
                            <li>• Unified social inbox</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- ROI Calculator Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-800 mb-4">
                        Calculate Your <span class="gradient-text">Savings</span>
                    </h2>
                    <p class="text-xl text-gray-600">
                        See how much time and money ReplyPilot can save your business
                    </p>
                </div>
                
                <div class="bg-gradient-to-r from-blue-50 to-purple-50 rounded-2xl p-8">
                    <div class="grid md:grid-cols-2 gap-8">
                        <div>
                            <h3 class="text-2xl font-bold text-gray-800 mb-6">Before ReplyPilot</h3>
                            <div class="space-y-4">
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Email Responses</span>
                                    <span class="font-bold text-red-600">2 hours/day</span>
                                </div>
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Review Management</span>
                                    <span class="font-bold text-red-600">1 hour/day</span>
                                </div>
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Total Daily Time</span>
                                    <span class="font-bold text-red-600">3 hours</span>
                                </div>
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Monthly Cost</span>
                                    <span class="font-bold text-red-600">$1,875</span>
                                </div>
                            </div>
                        </div>
                        
                        <div>
                            <h3 class="text-2xl font-bold text-gray-800 mb-6">After ReplyPilot</h3>
                            <div class="space-y-4">
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Email Responses</span>
                                    <span class="font-bold text-green-600">15 minutes/day</span>
                                </div>
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Review Management</span>
                                    <span class="font-bold text-green-600">5 minutes/day</span>
                                </div>
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Total Daily Time</span>
                                    <span class="font-bold text-green-600">20 minutes</span>
                                </div>
                                <div class="flex justify-between items-center p-4 bg-white rounded-lg">
                                    <span class="text-gray-600">Monthly Cost</span>
                                    <span class="font-bold text-green-600">$208</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-8 text-center">
                        <div class="bg-gradient-to-r from-green-500 to-green-600 text-white rounded-xl p-6">
                            <div class="text-3xl font-bold mb-2">$1,667</div>
                            <div class="text-lg">Monthly Savings (89% reduction)</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <section class="py-20 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-800 mb-4">
                        Simple, <span class="gradient-text">Transparent</span> Pricing
                    </h2>
                    <p class="text-xl text-gray-600">
                        Choose the plan that fits your business needs
                    </p>
                </div>
                
                <div class="grid md:grid-cols-3 gap-8">
                    <!-- Free Tier -->
                    <div class="bg-white rounded-xl p-8 shadow-lg">
                        <div class="text-center mb-8">
                            <h3 class="text-2xl font-bold text-gray-800 mb-2">Free</h3>
                            <div class="text-4xl font-bold gradient-text mb-2">$0</div>
                            <div class="text-gray-600">Perfect for testing</div>
                        </div>
                        <ul class="space-y-4 mb-8">
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>1 email account</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>50 AI responses/month</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Basic review management</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Email support</span>
                            </li>
                        </ul>
                        <a href="{{ route('login') }}" class="w-full bg-gray-200 hover:bg-gray-300 text-gray-800 py-3 rounded-lg font-bold text-center block transition-colors">
                            Start Free
                        </a>
                    </div>
                    
                    <!-- Pro Tier -->
                    <div class="bg-white rounded-xl p-8 shadow-lg border-2 border-blue-500 relative">
                        <div class="absolute -top-4 left-1/2 transform -translate-x-1/2">
                            <span class="bg-blue-500 text-white px-4 py-2 rounded-full text-sm font-bold">Most Popular</span>
                        </div>
                        <div class="text-center mb-8">
                            <h3 class="text-2xl font-bold text-gray-800 mb-2">Pro</h3>
                            <div class="text-4xl font-bold gradient-text mb-2">$29</div>
                            <div class="text-gray-600">per month</div>
                        </div>
                        <ul class="space-y-4 mb-8">
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>5 email accounts</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Unlimited AI responses</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Full review management</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Multi-AI providers</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Priority support</span>
                            </li>
                        </ul>
                        <a href="{{ route('login') }}" class="w-full bg-blue-500 hover:bg-blue-600 text-white py-3 rounded-lg font-bold text-center block transition-colors">
                            Start Pro Trial
                        </a>
                    </div>
                    
                    <!-- Agency Tier -->
                    <div class="bg-white rounded-xl p-8 shadow-lg">
                        <div class="text-center mb-8">
                            <h3 class="text-2xl font-bold text-gray-800 mb-2">Agency</h3>
                            <div class="text-4xl font-bold gradient-text mb-2">$99</div>
                            <div class="text-gray-600">per month</div>
                        </div>
                        <ul class="space-y-4 mb-8">
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>20 email accounts</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Multi-tenant support</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>White-label branding</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Role-based access</span>
                            </li>
                            <li class="flex items-center">
                                <span class="text-green-500 mr-3">✓</span>
                                <span>Dedicated support</span>
                            </li>
                        </ul>
                        <a href="{{ route('login') }}" class="w-full bg-purple-500 hover:bg-purple-600 text-white py-3 rounded-lg font-bold text-center block transition-colors">
                            Start Agency Trial
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-20 gradient-bg">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto text-center text-white">
                <h2 class="text-4xl font-bold mb-6">
                    Ready to Save 2+ Hours Daily?
                </h2>
                <p class="text-xl mb-8 text-gray-200">
                    Join 500+ businesses already using ReplyPilot to streamline their customer communication
                </p>
                
                <div class="flex flex-col sm:flex-row gap-4 justify-center mb-8">
                    <a href="{{ route('login') }}" class="bg-yellow-400 hover:bg-yellow-500 text-gray-900 px-8 py-4 rounded-lg font-bold text-lg transition-all duration-300 transform hover:scale-105">
                        Start Your Free Trial
                    </a>
                    <a href="#contact" class="border-2 border-white text-white hover:bg-white hover:text-gray-900 px-8 py-4 rounded-lg font-bold text-lg transition-all duration-300">
                        Contact Sales
                    </a>
                </div>
                
                <div class="text-sm text-gray-300">
                    <span class="text-green-400 mr-2">✓</span>
                    14-day free trial • No credit card required • Setup in 5 minutes
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-12">
        <div class="container mx-auto px-4">
            <div class="max-w-6xl mx-auto">
                <div class="grid md:grid-cols-4 gap-8">
                    <div>
                        <div class="flex items-center mb-4">
                            <div class="w-8 h-8 bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg mr-3 flex items-center justify-center">
                                <span class="text-white text-sm font-bold">RP</span>
                            </div>
                            <span class="text-xl font-bold">ReplyPilot</span>
                        </div>
                        <p class="text-gray-400 mb-4">
                            The only AI-powered platform that manages both emails and reviews.
                        </p>
                    </div>
                    
                    <div>
                        <h4 class="font-bold mb-4">Product</h4>
                        <ul class="space-y-2 text-gray-400">
                            <li><a href="#" class="hover:text-white transition-colors">Features</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Pricing</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Integrations</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">API</a></li>
                        </ul>
                    </div>
                    
                    <div>
                        <h4 class="font-bold mb-4">Support</h4>
                        <ul class="space-y-2 text-gray-400">
                            <li><a href="#" class="hover:text-white transition-colors">Documentation</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Help Center</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Contact Us</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Status</a></li>
                        </ul>
                    </div>
                    
                    <div>
                        <h4 class="font-bold mb-4">Company</h4>
                        <ul class="space-y-2 text-gray-400">
                            <li><a href="#" class="hover:text-white transition-colors">About</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Blog</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Careers</a></li>
                            <li><a href="#" class="hover:text-white transition-colors">Privacy</a></li>
                        </ul>
                    </div>
                </div>
                
                <div class="border-t border-gray-700 mt-8 pt-8 text-center text-gray-400">
                    <p>&copy; 2025 ReplyPilot. All rights reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- JavaScript for animations -->
    <script>
        // Intersection Observer for slide-in animations
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe all slide-in elements
        document.querySelectorAll('.slide-in').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(30px)';
            el.style.transition = 'opacity 0.8s ease, transform 0.8s ease';
            observer.observe(el);
        });

        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });
    </script>
</body>
</html>
