@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gray-50 py-12">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Add SMTP+IMAP Account</h1>
                    <p class="mt-2 text-gray-600">Configure an email account with both sending (SMTP) and receiving (IMAP) capabilities</p>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('email.accounts') }}" 
                       class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                        Back to Accounts
                    </a>
                </div>
            </div>
        </div>

        <!-- Settings Form -->
        <div class="bg-white shadow rounded-lg">
            <form method="POST" action="{{ route('smtp-imap.store') }}" class="space-y-8 p-6">
                @csrf

                <!-- Basic Information -->
                <div>
                    <h3 class="text-lg font-medium text-gray-900 mb-4">📧 Basic Information</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                            <input type="email" name="email" id="email" required placeholder="admin@yourdomain.com"
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-lg focus:ring-blue-500">
                            <p class="mt-1 text-xs text-gray-500">The email address for this account</p>
                        </div>
                        
                        <div>
                            <label for="from_name" class="block text-sm font-medium text-gray-700">From Name</label>
                            <input type="text" name="from_name" id="from_name" required placeholder="Your Business Name"
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <p class="mt-1 text-xs text-gray-500">Name that appears in emails you send</p>
                        </div>
                    </div>
                </div>

                <!-- SMTP Configuration -->
                <div>
                    <h3 class="text-lg font-medium text-gray-900 mb-4">📤 SMTP Settings (for sending emails)</h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <div class="lg:col-span-2">
                            <label for="smtp_host" class="block text-sm font-medium text-gray-700">SMTP Host</label>
                            <input type="text" name="smtp_host" id="smtp_host" required placeholder="e.g., mail.yourdomain.com"
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <p class="mt-1 text-xs text-gray-500">Common: mail.yourdomain.com, smtp.hostinger.com</p>
                        </div>
                        
                        <div>
                            <label for="smtp_port" class="block text-sm font-medium text-gray-700">Port</label>
                            <select name="smtp_port" id="smtp_port" required
                                    class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">Select Port</option>
                                <option value="587" selected>587 (TLS - Recommended)</option>
                                <option value="465">465 (SSL)</option>
                                <option value="25">25 (Unsecured)</option>
                            </select>
                        </div>
                        
                        <div class="lg:col-span-3">
                            <label for="smtp_encryption" class="block text-sm font-medium text-gray-700">Encryption</label>
                            <select name="smtp_encryption" id="smtp_encryption" required
                                    class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">Select Encryption</option>
                                <option value="tls" selected>TLS (recommended)</option>
                                <option value="ssl">SSL</option>
                                <option value="none">None (not secure)</option>
                            </select>
                        </div>
                        
                        <div class="lg:col-span-2">
                            <label for="smtp_username" class="block text-sm font-medium text-gray-700">Username</label>
                            <input type="text" name="smtp_username" id="smtp_username" required placeholder="Full email address"
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                        
                        <div>
                            <label for="smtp_password" class="block text-sm font-medium text-gray-700">Password</label>
                            <input type="password" name="smtp_password" id="smtp_password" required placeholder="Email password or app password"
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                        
                        <div class="lg:col-span-3">
                            <label for="smtp_from_name" class="block text-sm font-medium text-gray-700">SMTP From Name (optional)</label>
                            <input type="text" name="smtp_from_name" id="smtp_from_name" placeholder="Leave blank to use basic from_name above"
                                   class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                    </div>
                </div>

                <!-- IMAP Configuration -->
                <div>
                    <div class="flex items-center mb-4">
                        <input type="checkbox" name="enable_imap" id="enable_imap" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                        <label for="enable_imap" class="ml-2 text-lg font-medium text-gray-900">📥 Enable IMAP (for receiving emails)</label>
                    </div>
                    
                    <div id="imap_settings" class="hidden space-y-6">
                        <p class="text-sm text-gray-600">Enable IMAP to fetch emails from this account. You'll be able to see incoming emails and generate AI replies.</p>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                            <div class="lg:col-span-2">
                                <label for="imap_host" class="block text-sm font-medium text-gray-700">IMAP Host</label>
                                <input type="text" name="imap_host" id="imap_host" placeholder="e.g., mail.yourdomain.com"
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <p class="mt-1 text-xs text-gray-500">Usually same as SMTP host</p>
                            </div>
                            
                            <div>
                                <label for="imap_port" class="block text-sm font-medium text-gray-700">IMAP Port</label>
                                <select name="imap_port" id="imap_port"
                                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="">Select Port</option>
                                    <option value="993" selected>993 (SSL - Recommended)</option>
                                    <option value="143">143 (TLS)</option>
                                    <option value="110">110 (POP3)</option>
                                </select>
                            </div>
                            
                            <div class="lg:col-span-3">
                                <label for="imap_encryption" class="block text-sm font-medium text-gray-700">IMAP Encryption</label>
                                <select name="imap_encryption" id="imap_encryption"
                                        class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                    <option value="">Select Encryption</option>
                                    <option value="ssl" selected>SSL (secure)</option>
                                    <option value="tls">TLS</option>
                                    <option value="none">None (not secure)</option>
                                </select>
                            </div>
                            
                            <div class="lg:col-span-2">
                                <label for="imap_username" class="block text-sm font-medium text-gray-700">IMAP Username</label>
                                <input type="text" name="imap_username" id="imap_username" placeholder="Full email address"
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            </div>
                            
                            <div>
                                <label for="imap_password" class="block text-sm font-medium text-gray-700">IMAP Password</label>
                                <input type="password" name="imap_password" id="imap_password" placeholder="Same as SMTP password"
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            </div>
                            
                            <div class="lg:col-span-3">
                                <label for="imap_folder" class="block text-sm font-medium text-gray-700">IMAP Folder</label>
                                <input type="text" name="imap_folder" id="imap_folder" placeholder="INBOX (default)"
                                       class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <p class="mt-1 text-xs text-gray-500">Folder to fetch emails from (leave blank for INBOX)</p>
                            </div>
                        </div>
                        
                        <!-- IMAP Test Button -->
                        <div>
                            <button type="button" onclick="testImapConnection()" id="test-imap-btn"
                                    class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                Test IMAP Connection
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Advanced Options -->
                <div>
                    <h3 class="text-lg font-medium text-gray-900 mb-4">⚙️ Advanced and Options</h3>
                    
                    <div class="space-y-4">
                        <div class="flex items-center">
                            <input type="checkbox" name="make_primary" id="make_primary" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="make_primary" class="ml-2 block text-sm text-gray-900">Set as primary email account</label>
                        </div>
                        
                        <div class="flex items-center">
                            <input type="checkbox" name="enable_auto_fetch" id="enable_auto_fetch" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="enable_auto_fetch" class="ml-2 block text-sm text-gray-900">Schedule automatic email fetching (if IMAP enabled)</label>
                        </div>
                    </div>
                </div>

                <!-- Helpful Tips -->
                <div class="p-4 bg-yellow-50 rounded-lg border border-yellow-200">
                    <h4 class="text-sm font-medium text-yellow-800 mb-2">💡 Quick Setup Tips:</h4>
                    <ul class="text-xs text-yellow-700 space-y-1">
                        <li><strong>For Hostinger:</strong> SMTP: mail.yourdomain.com:587 TLS | IMAP: mail.yourdomain.com:993 SSL</li>
                        <li><strong>For GoDaddy:</strong> SMTP: smtpout.secureserver.net:465 SSL | IMAP: imap.secureserver.net:993 SSL</li>
                        <li><strong>For Gmail:</strong> Use SMTP+IMAP with App Password (not regular password)</li>
                        <li><strong>Encryption:</strong> Always use TLS/SSL for security</li>
                        <li>Test connections before saving the account</li>
                    </ul>
                </div>

                <!-- Submit Buttons -->
                <div class="flex items-center justify-between">
                    <a href="{{ route('email.accounts') }}" 
                       class="inline-flex items-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500">
                        Cancel
                    </a>
                    
                    <button type="submit" 
                            class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                        Create SMTP+IMAP Account
                    </button>
                </div>
            </form>

            <!-- Messages Container -->
            <div id="messages" class="p-6 hidden">
                <!-- Success/Error messages will appear here -->
            </div>
        </div>
    </div>
</div>

<script>
// Toggle IMAP settings visibility
document.getElementById('enable_imap').addEventListener('change', function() {
    const imapSettings = document.getElementById('imap_settings');
    if (this.checked) {
        imapSettings.classList.remove('hidden');
        
        // Auto-fill IMAP fields with SMTP values
        if (!document.getElementById('imap_host').value) {
            document.getElementById('imap_host').value = document.getElementById('smtp_host').value;
        }
        if (!document.getElementById('imap_username').value) {
            document.getElementById('imap_username').value = document.getElementById('smtp_username').value;
        }
    } else {
        imapSettings.classList.add('hidden');
    }
});

// Auto-fill IMAP folder if empty
document.getElementById('imap_folder').addEventListener('focus', function() {
    if (!this.value) {
        this.value = 'INBOX';
    }
});

// Test IMAP Connection
function testImapConnection() {
    const enableImap = document.getElementById('enable_imap').checked;
    if (!enableImap) {
        showMessage('❌ Please enable IMAP first', 'error');
        return;
    }

    const imapHost = document.getElementById('imap_host').value;
    const imapPort = document.getElementById('imap_port').value;
    const imapEncryption = document.getElementById('imap_encryption').value;
    const imapUsername = document.getElementById('imap_username').value;
    const imapPassword = document.getElementById('imap_password').value;
    
    if (!imapHost || !imapPort || !imapEncryption || !imapUsername || !imapPassword) {
        showMessage('❌ Please fill in all IMAP settings', 'error');
        return;
    }

    const btn = document.getElementById('test-imap-btn');
    const originalText = btn.innerHTML;
    btn.disabled = true;
    btn.innerHTML = '<svg class="w-4 h-4 mr-2 animate-spin" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>Testing Connection...';

    fetch('{{ route("imap.test-connection") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            imap_host: imapHost,
            imap_port: parseInt(imapPort),
            imap_encryption: imapEncryption,
            imap_username: imapUsername,
            imap_password: imapPassword,
            imap_folder: document.getElementById('imap_folder').value || 'INBOX'
        })
    })
    .then(response => {
        // Check if response is ok
        if (!response.ok) {
            throw new Error(`HTTP ${response.status}: ${response.statusText}`);
        }
        
        // Try to parse JSON
        return response.text().then(text => {
            try {
                return JSON.parse(text);
            } catch (e) {
                console.error('Invalid JSON response:', text);
                throw new Error('Invalid JSON response: ' + text.substring(0, 200) + '...');
            }
        });
    })
    .then(data => {
        if (data && typeof data === 'object' && 'message' in data) {
            showMessage(data.message, data.success ? 'success' : 'error');
        } else {
            showMessage('❌ Unexpected response format', 'error');
        }
    })
    .catch(error => {
        console.error('IMAP test error:', error);
        showMessage('❌ Connection error: ' + error.message, 'error');
    })
    .finally(() => {
        btn.disabled = false;
        btn.innerHTML = originalText;
    });
}

// Show success/error messages
function showMessage(message, type) {
    const container = document.getElementById('messages');
    const icon = type === 'success' ? '✅' : '❌';
    const bgColor = type === 'success' ? 'bg-green-50 border-green-200' : 'bg-red-50 border-red-200';
    const textColor = type === 'success' ? 'text-green-700' : 'text-red-700';
    
    container.innerHTML = `
        <div class="${bgColor} border ${textColor} p-4 rounded-lg">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <span class="text-2xl mr-3">${icon}</span>
                    <div>
                        <h4 class="text-sm font-medium">${type === 'success' ? 'Success' : 'Error'}</h4>
                        <div class="text-sm mt-1 whitespace-pre-line">${message}</div>
                    </div>
                </div>
                <button onclick="clearMessages()" class="ml-4 text-gray-400 hover:text-gray-600 focus:outline-none">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
    `;
    container.classList.remove('hidden');
    
    // Scroll to message
    container.scrollIntoView({ behavior: 'smooth', block: 'center' });
}

// Clear messages manually
function clearMessages() {
    const container = document.getElementById('messages');
    container.innerHTML = '';
    container.classList.add('hidden');
}
</script>
@endsection
