<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class EmailProviderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('email_providers')->insert([
            [
                'id' => 'hostinger',
                'name' => 'Hostinger',
                'description' => 'Hostinger webmail accounts',
                'smtp_settings' => json_encode([
                    'host' => 'mail.yourdomain.com',
                    'port' => 587,
                    'encryption' => 'tls',
                    'username_field' => 'email',
                    'password_field' => 'password',
                    'requires_app_password' => false,
                ]),
                'imap_settings' => json_encode([
                    'host' => 'mail.yourdomain.com',
                    'port' => 993,
                    'encryption' => 'ssl',
                ]),
                'support_url' => 'https://support.hostinger.com/en/articles/configuring-email-in-thunderbird-manually',
                'logo_url' => null,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 'cpanel',
                'name' => 'cPanel Email',
                'description' => 'Generic cPanel hosted email accounts',
                'smtp_settings' => json_encode([
                    'host' => 'yourdomain.com',
                    'port' => 587,
                    'encryption' => 'tls',
                    'username_field' => 'email',
                    'password_field' => 'password',
                    'requires_app_password' => false,
                ]),
                'imap_settings' => json_encode([
                    'host' => 'yourdomain.com',
                    'port' => 993,
                    'encryption' => 'ssl',
                ]),
                'support_url' => 'https://www.cpanel.net/docs/mail-server-configuration/',
                'logo_url' => null,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 'godaddy',
                'name' => 'GoDaddy',
                'description' => 'GoDaddy hosted email accounts',
                'smtp_settings' => json_encode([
                    'host' => 'smtpout.secureserver.net',
                    'port' => 465,
                    'encryption' => 'ssl',
                    'username_field' => 'email',
                    'password_field' => 'password',
                    'requires_app_password' => false,
                ]),
                'imap_settings' => json_encode([
                    'host' => 'imap.secureserver.net',
                    'port' => 993,
                    'encryption' => 'ssl',
                ]),
                'support_url' => 'https://support.godaddy.com/help/19328',
                'logo_url' => null,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => 'custom',
                'name' => 'Custom SMTP',
                'description' => 'Custom SMTP server configuration',
                'smtp_settings' => json_encode([
                    'host' => '',
                    'port' => 587,
                    'encryption' => 'tls',
                    'username_field' => 'email',
                    'password_field' => 'password',
                    'requires_app_password' => false,
                ]),
                'imap_settings' => json_encode([
                    'host' => '',
                    'port' => 993,
                    'encryption' => 'ssl',
                ]),
                'support_url' => null,
                'logo_url' => null,
                'is_active' => true,
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }
}