<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create default tenant (or get existing)
        $defaultTenant = Tenant::firstOrCreate(
            ['slug' => 'default'],
            [
                'name' => 'Default Business',
                'domain' => null,
                'settings' => [
                    'timezone' => 'UTC',
                    'date_format' => 'Y-m-d',
                    'time_format' => 'H:i:s',
                ],
                'is_active' => true,
            ]
        );

        // Create Super Admin (no tenant assignment)
        User::firstOrCreate(
            ['email' => 'test@example.com'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('password'),
                'role' => 'super_admin',
                'tenant_id' => null,
                'is_active' => true,
                'email_verified_at' => now(),
                'settings' => [
                    'theme' => 'light',
                    'notifications' => true,
                ],
            ]
        );

        // Create Tenant Admin
        User::firstOrCreate(
            ['email' => 'iyallawalcourt@gmail.com'],
            [
                'name' => 'Tenant Admin',
                'password' => Hash::make('password'),
                'role' => 'tenant_admin',
                'tenant_id' => $defaultTenant->id,
                'is_active' => true,
                'email_verified_at' => now(),
                'settings' => [
                    'theme' => 'light',
                    'notifications' => true,
                ],
            ]
        );

        // Call other seeders
        $this->call([
            EmailProviderSeeder::class,
        ]);

        $this->command->info('✅ Demo accounts created successfully!');
        $this->command->info('Super Admin: test@example.com / password');
        $this->command->info('Tenant Admin: iyallawalcourt@gmail.com / password');
    }
}
