<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * Adds soft delete support to key models for audit trail compliance.
     * This allows recovering deleted records and maintaining history.
     */
    public function up(): void
    {
        // Add soft deletes to reviews table
        if (!Schema::hasColumn('reviews', 'deleted_at')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Add soft deletes to review_drafts table
        if (!Schema::hasColumn('review_drafts', 'deleted_at')) {
            Schema::table('review_drafts', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Add soft deletes to threads table
        if (!Schema::hasColumn('threads', 'deleted_at')) {
            Schema::table('threads', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Add soft deletes to messages table
        if (!Schema::hasColumn('messages', 'deleted_at')) {
            Schema::table('messages', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Add soft deletes to email_drafts table
        if (!Schema::hasColumn('email_drafts', 'deleted_at')) {
            Schema::table('email_drafts', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Add soft deletes to mail_accounts table
        if (!Schema::hasColumn('mail_accounts', 'deleted_at')) {
            Schema::table('mail_accounts', function (Blueprint $table) {
                $table->softDeletes();
            });
        }

        // Add soft deletes to locations table
        if (!Schema::hasColumn('locations', 'deleted_at')) {
            Schema::table('locations', function (Blueprint $table) {
                $table->softDeletes();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('reviews', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('review_drafts', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('threads', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('messages', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('email_drafts', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('mail_accounts', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });

        Schema::table('locations', function (Blueprint $table) {
            $table->dropSoftDeletes();
        });
    }
};
