<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * Add performance indexes for common query patterns
     */
    public function up(): void
    {
        // Add individual tenant_id indexes for tenant-only queries
        $tables = [
            'reviews',
            'review_drafts',
            'threads',
            'messages',
            'email_drafts',
            'mail_accounts',
            'locations',
            'oauth_connections',
        ];

        foreach ($tables as $table) {
            if (Schema::hasTable($table) && Schema::hasColumn($table, 'tenant_id')) {
                Schema::table($table, function (Blueprint $table) {
                    // Add individual tenant_id index if it doesn't exist
                    $table->index('tenant_id', $table->getTable() . '_tenant_id_index');
                });
            }
        }

        // Add status indexes for common status-based queries
        if (Schema::hasTable('reviews') && Schema::hasColumn('reviews', 'status')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->index('status');
            });
        }

        if (Schema::hasTable('review_drafts') && Schema::hasColumn('review_drafts', 'status')) {
            Schema::table('review_drafts', function (Blueprint $table) {
                $table->index('status');
            });
        }

        if (Schema::hasTable('email_drafts') && Schema::hasColumn('email_drafts', 'status')) {
            Schema::table('email_drafts', function (Blueprint $table) {
                $table->index('status');
            });
        }

        // Add created_at indexes for time-based queries
        if (Schema::hasTable('reviews')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->index('created_at');
            });
        }

        if (Schema::hasTable('messages')) {
            Schema::table('messages', function (Blueprint $table) {
                $table->index('created_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $tables = [
            'reviews',
            'review_drafts',
            'threads',
            'messages',
            'email_drafts',
            'mail_accounts',
            'locations',
            'oauth_connections',
        ];

        foreach ($tables as $table) {
            if (Schema::hasTable($table)) {
                Schema::table($table, function (Blueprint $blueprint) use ($table) {
                    $blueprint->dropIndex($table . '_tenant_id_index');
                });
            }
        }

        // Drop additional indexes
        if (Schema::hasTable('reviews')) {
            Schema::table('reviews', function (Blueprint $table) {
                $table->dropIndex(['status']);
                $table->dropIndex(['created_at']);
            });
        }

        if (Schema::hasTable('review_drafts')) {
            Schema::table('review_drafts', function (Blueprint $table) {
                $table->dropIndex(['status']);
            });
        }

        if (Schema::hasTable('email_drafts')) {
            Schema::table('email_drafts', function (Blueprint $table) {
                $table->dropIndex(['status']);
            });
        }

        if (Schema::hasTable('messages')) {
            Schema::table('messages', function (Blueprint $table) {
                $table->dropIndex(['created_at']);
            });
        }
    }
};


