<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('reviews', function (Blueprint $table) {
            // Add multi-tenant columns
            $table->uuid('user_id')->nullable()->after('id');
            $table->unsignedBigInteger('tenant_id')->nullable()->after('user_id');

            // Add foreign key constraints
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('tenant_id')->references('id')->on('tenants')->onDelete('cascade');
            
            // Add indexes for better performance
            $table->index(['user_id', 'tenant_id']);
            $table->index(['tenant_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('reviews', function (Blueprint $table) {
            // Drop foreign key constraints
            $table->dropForeign(['user_id']);
            $table->dropForeign(['tenant_id']);
            
            // Drop indexes
            $table->dropIndex(['user_id', 'tenant_id']);
            $table->dropIndex(['tenant_id', 'status']);
            
            // Drop columns
            $table->dropColumn(['user_id', 'tenant_id']);
        });
    }
};