<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('email_drafts', function (Blueprint $table) {
            $table->longText('editor_content')->nullable()->after('draft_html');
            $table->enum('editor_type', ['html', 'markdown', 'plain'])->default('html')->after('editor_content');
            $table->string('template_id')->nullable()->after('editor_type');
            $table->integer('version_number')->default(1)->after('template_id');
            $table->integer('ai_regeneration_count')->default(0)->after('version_number');
            $table->json('editor_meta')->nullable()->after('ai_regeneration_count');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('email_drafts', function (Blueprint $table) {
            $table->dropColumn([
                'editor_content',
                'editor_type', 
                'template_id',
                'version_number',
                'ai_regeneration_count',
                'editor_meta'
            ]);
        });
    }
};
