<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('email_drafts', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('thread_id')->constrained()->onDelete('cascade');
            $table->foreignUuid('in_reply_to_message_id')->nullable()->constrained('messages')->onDelete('set null');
            $table->string('subject');
            $table->longText('draft_html');
            $table->json('ai_meta');
            $table->enum('status', ['pending', 'approved', 'sent', 'rejected'])->default('pending');
            $table->foreignUuid('approved_by_user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamp('approved_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('email_drafts');
    }
};
