<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('messages', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('thread_id')->constrained()->onDelete('cascade');
            $table->string('provider_msg_id');
            $table->enum('direction', ['inbound', 'outbound']);
            $table->string('from_addr');
            $table->json('to_json');
            $table->json('cc_json')->nullable();
            $table->json('bcc_json')->nullable();
            $table->timestamp('date');
            $table->text('snippet');
            $table->longText('body_text');
            $table->longText('body_html');
            $table->json('attachments')->nullable();
            $table->json('ai_tags')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('messages');
    }
};
