<?php

namespace Database\Factories;

use App\Models\Review;
use App\Models\Location;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Review>
 */
class ReviewFactory extends Factory
{
    protected $model = Review::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'user_id' => null,
            'tenant_id' => null,
            'location_id' => Location::factory(),
            'source' => 'google_gbp',
            'external_review_id' => fake()->uuid(),
            'stars' => fake()->numberBetween(1, 5),
            'lang' => 'en',
            'text' => fake()->paragraph(),
            'status' => 'new',
            'reviewed_at' => now(),
        ];
    }

    /**
     * Set the review status to drafted.
     */
    public function drafted(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'drafted',
        ]);
    }

    /**
     * Set the review status to posted.
     */
    public function posted(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'posted',
        ]);
    }

    /**
     * Set the review with high rating.
     */
    public function positive(): static
    {
        return $this->state(fn (array $attributes) => [
            'stars' => fake()->numberBetween(4, 5),
        ]);
    }

    /**
     * Set the review with low rating.
     */
    public function negative(): static
    {
        return $this->state(fn (array $attributes) => [
            'stars' => fake()->numberBetween(1, 2),
        ]);
    }
}
