<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Email Cleanup Configuration
    |--------------------------------------------------------------------------
    |
    | Configuration options for automated email cleanup
    |
    */

    'retention_period' => env('EMAIL_RETENTION_HOURS', 24),

    'cleanup_strategies' => [
        // Clean up threads older than X hours with no active drafts
        'threads_without_drafts' => true,
        
        // Clean up orphaned messages
        'orphaned_messages' => true,
        
        // Clean up drafts older than X hours (optional)
        'drafts' => false,
    ],

    'exclusions' => [
        // Don't delete threads that have been replied to in last X hours
        'protect_recent_replies' => true,
        
        // Don't delete threads with important flags/tags
        'protect_important_threads' => true,
    ],

    'schedule' => [
        // Default schedule time (24 hours)
        'frequency' => 'daily',
        
        // Run at this time (2 AM)
        'time' => '02:00',
        
        // Alternative: More frequent cleanup
        'frequent_cleanup' => false,
        'frequent_hours' => 6,
    ],

    'logging' => [
        'enabled' => true,
        'log_deletions' => true,
        'log_stats' => true,
    ],
];
