<?php

namespace App\Support;

use Mews\Purifier\Facades\Purifier;

class EmailSanitizer
{
    public static function clean(?string $raw): string
    {
        if (!$raw) return '';

        // 1) Decode HTML entities
        $html = html_entity_decode($raw, ENT_QUOTES | ENT_HTML5, 'UTF-8');

        // 2) Remove anything before first HTML tag (common in raw emails)
        $firstTag = strpos($html, '<');
        if ($firstTag !== false) {
            $html = substr($html, $firstTag);
        }

        // 3) Remove unwanted tags and CSS definitions
        $patterns = [
            // Remove <style>, <script>, <head>, etc.
            '#<style\b[^>]*>.*?</style>#is',
            '#<script\b[^>]*>.*?</script>#is',
            '#<head\b[^>]*>.*?</head>#is',
            '#<noscript\b[^>]*>.*?</noscript>#is',
            '#<iframe\b[^>]*>.*?</iframe>#is',
            '#<link\b[^>]*?>#is',
            '#<meta\b[^>]*?>#is',
            '#<!--.*?-->#s',

            // ✅ Remove ALL standalone/bare CSS rules anywhere in text
            // Matches "selector{...}" globally even if concatenated
            '#[a-zA-Z0-9\*\.\#\[\]=_\-:\@\s,]+?\{[^{}]*\}#m',
        ];

        $html = preg_replace($patterns, '', $html) ?? '';

        // 4) Remove lingering @media or malformed CSS fragments
        $html = preg_replace('#@media[^{]*\{[^}]*\}#is', '', $html);

        // 5) Optional: deeply clean using Purifier if available
        // if (class_exists(Purifier::class)) {
        //     $html = Purifier::clean($html, 'email');
        // }

        return trim($html);
    }
}
