<?php

use App\Modules\SMTP\Controllers\SMTPController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| SMTP Module Routes
|--------------------------------------------------------------------------
|
| Here is where you can register SMTP module routes for your application.
| These routes are loaded by the SMTPServiceProvider.
|
*/

Route::middleware(['auth'])->group(function () {
    // SMTP account management
    Route::get('/smtp/accounts', [SMTPController::class, 'index'])->name('smtp.accounts.index');
    Route::post('/smtp/accounts', [SMTPController::class, 'store'])->name('smtp.accounts.store');
    Route::get('/smtp/accounts/{account}/edit', [SMTPController::class, 'edit'])->name('smtp.accounts.edit');
    Route::put('/smtp/accounts/{account}', [SMTPController::class, 'update'])->name('smtp.accounts.update');
    Route::delete('/smtp/accounts/{account}', [SMTPController::class, 'destroy'])->name('smtp.accounts.delete');
    
    // SMTP operations
    Route::post('/smtp/test-connection', [SMTPController::class, 'testConnection'])->name('smtp.test-connection');
    Route::post('/smtp/send-email', [SMTPController::class, 'sendEmail'])->name('smtp.send-email');
    Route::post('/smtp/fetch-emails', [SMTPController::class, 'fetchEmails'])->name('smtp.fetch-emails');
    
    // IMAP operations
    Route::post('/smtp/imap/test', [SMTPController::class, 'testImapConnection'])->name('smtp.imap.test');
    Route::post('/smtp/imap/fetch', [SMTPController::class, 'fetchImapEmails'])->name('smtp.imap.fetch');
});
