<?php

namespace App\Modules\Gmail;

use Illuminate\Support\ServiceProvider;

class GmailServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Register Gmail-specific services
        $this->app->singleton('gmail.service', function ($app) {
            return new Services\GmailService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Load Gmail module routes
        $this->loadRoutesFrom(__DIR__ . '/Routes/gmail.php');
        
        // Load Gmail module views
        $this->loadViewsFrom(__DIR__ . '/Views', 'gmail');
        
        // Load Gmail module migrations
        $this->loadMigrationsFrom(__DIR__ . '/Database/Migrations');
    }
}
