<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\BelongsToUser;

class Review extends Model
{
    use HasUuids, HasFactory, BelongsToUser, SoftDeletes;

    protected $fillable = [
        'user_id',
        'tenant_id',
        'location_id',
        'source',
        'external_review_id',
        'stars',
        'lang',
        'text',
        'status',
        'reviewed_at',
    ];

    protected function casts(): array
    {
        return [
            'reviewed_at' => 'datetime',
        ];
    }

    /**
     * Location this review belongs to
     */
    public function location(): BelongsTo
    {
        return $this->belongsTo(Location::class);
    }

    /**
     * User that owns this review
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Tenant that owns this review
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }

    /**
     * Drafts for this review
     */
    public function drafts(): HasMany
    {
        return $this->hasMany(ReviewDraft::class);
    }

    /**
     * Get the latest draft
     */
    public function latestDraft()
    {
        return $this->drafts()->latest()->first();
    }
}
