<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Tenant;
use Symfony\Component\HttpFoundation\Response;

class TenantContext
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = Auth::user();
        
        if (!$user) {
            return $next($request);
        }

        // Set tenant context for the request
        if ($user->isSuperAdmin()) {
            // Super admin can access any tenant
            $tenantId = $request->get('tenant_id') ?? $user->tenant_id;
        } else {
            // Regular users are bound to their tenant
            $tenantId = $user->tenant_id;
        }

        if ($tenantId) {
            $tenant = Tenant::find($tenantId);
            if ($tenant) {
                // Set tenant in request for easy access
                $request->merge(['tenant' => $tenant]);
                
                // Set tenant context in config for global access
                config(['tenant' => $tenant]);
            }
        }

        return $next($request);
    }
}
