<?php

namespace App\Http\Controllers\TenantAdmin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    /**
     * Display settings page for tenant admin
     */
    public function index()
    {
        return view('tenant-admin.settings.index');
    }

    /**
     * Update auto-ingestion interval settings for this tenant
     */
    public function updateIngestionInterval(Request $request)
    {
        $request->validate([
            'email_interval' => 'required|string',
            'email_custom_interval' => 'nullable|integer|min:1|max:1440',
            'review_interval' => 'required|string',
            'review_custom_interval' => 'nullable|integer|min:1|max:1440',
        ]);

        // Determine final email interval
        $emailInterval = $request->email_interval === 'custom'
            ? $request->email_custom_interval
            : (int) $request->email_interval;

        // Determine final review interval
        $reviewInterval = $request->review_interval === 'custom'
            ? $request->review_custom_interval
            : (int) $request->review_interval;

        // Tenant admin sets settings for their own tenant
        $tenant = auth()->user()->tenant;

        if ($tenant) {
            $settings = $tenant->settings ?? [];
            $settings['email_ingestion_interval'] = $emailInterval;
            $settings['review_ingestion_interval'] = $reviewInterval;
            $tenant->update(['settings' => $settings]);
        }

        return redirect()
            ->route('tenant-admin.settings.index')
            ->with('success', 'Auto-ingestion interval settings updated successfully!');
    }
}
