<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    public function edit(Request $request)
    {
        return view('profile.edit', [
            'user' => $request->user(),
        ]);
    }

    public function update(Request $request)
    {
        $user = $request->user();

        $validated = $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'email', 'max:255', 'unique:users,email,' . $user->id],
            'current_password' => ['nullable', 'string'],
            'password' => ['nullable', 'string', 'min:8', 'confirmed'],
        ]);

        $emailChanged = $validated['email'] !== $user->email;
        $passwordChanging = (bool) $request->filled('password');

        if ($emailChanged || $passwordChanging) {
            $currentPassword = (string) $request->input('current_password', '');
            if ($currentPassword === '' || !Hash::check($currentPassword, $user->password)) {
                return back()
                    ->withErrors(['current_password' => 'Current password is required to change email or password.'])
                    ->withInput();
            }
        }

        $user->name = $validated['name'];
        $user->email = $validated['email'];

        if ($passwordChanging) {
            $user->password = Hash::make($validated['password']);
        }

        $user->save();

        return back()->with('success', 'Profile updated successfully.');
    }
}
