<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Auth;

class RoleBasedNavigation
{
    /**
     * Get the correct email index route based on user role
     */
    public static function getEmailIndexRoute(): string
    {
        $user = Auth::user();
        
        if ($user->isSuperAdmin()) {
            return route('super-admin.email.index');
        } elseif ($user->isTenantAdmin()) {
            return route('tenant-admin.email.index');
        } elseif ($user->isAgent()) {
            return route('agent.email.index');
        }
        
        // Fallback to legacy route
        return route('email.index');
    }
    
    /**
     * Get the correct bulk delete route based on user role
     */
    public static function getBulkDeleteRoute(): string
    {
        $user = Auth::user();
        
        if ($user->isSuperAdmin()) {
            return route('super-admin.email.bulk-delete');
        } elseif ($user->isTenantAdmin()) {
            return route('tenant-admin.email.bulk-delete');
        } elseif ($user->isAgent()) {
            return route('agent.email.bulk-delete');
        }
        
        // Fallback to legacy route
        return route('email.threads.bulk-delete');
    }
    
    /**
     * Get the correct thread delete route based on user role
     */
    public static function getThreadDeleteRoute($thread): string
    {
        $user = Auth::user();
        
        if ($user->isSuperAdmin()) {
            return route('super-admin.email.thread.delete', $thread);
        } elseif ($user->isTenantAdmin()) {
            return route('tenant-admin.email.thread.delete', $thread);
        } elseif ($user->isAgent()) {
            return route('agent.email.thread.delete', $thread);
        }
        
        // Fallback to legacy route
        return route('email.thread.delete', $thread);
    }
    
    /**
     * Get the correct reviews index route based on user role
     */
    public static function getReviewsIndexRoute(): string
    {
        $user = Auth::user();
        
        if ($user->isSuperAdmin()) {
            return route('super-admin.reviews.index');
        } elseif ($user->isTenantAdmin()) {
            return route('tenant-admin.reviews.index');
        } elseif ($user->isAgent()) {
            return route('agent.reviews.index');
        }
        
        // Fallback to legacy route
        return route('reviews.index');
    }
    
    /**
     * Get the correct reviews bulk delete route based on user role
     */
    public static function getReviewsBulkDeleteRoute(): string
    {
        $user = Auth::user();
        
        if ($user->isSuperAdmin()) {
            return route('super-admin.reviews.bulk-delete');
        } elseif ($user->isTenantAdmin()) {
            return route('tenant-admin.reviews.bulk-delete');
        } elseif ($user->isAgent()) {
            return route('agent.reviews.bulk-delete');
        }
        
        // Fallback to legacy route
        return route('reviews.bulk-delete');
    }
}
