<?php

namespace App\Contracts;

interface AIProviderInterface
{
    /**
     * Generate a response using the AI provider
     *
     * @param string $systemPrompt
     * @param string $userPrompt
     * @param array $options
     * @return array
     */
    public function generateResponse(string $systemPrompt, string $userPrompt, array $options = []): array;

    /**
     * Test the connection to the AI provider
     *
     * @return array
     */
    public function testConnection(): array;

    /**
     * Get the provider name
     *
     * @return string
     */
    public function getProviderName(): string;

    /**
     * Check if the provider is properly configured
     *
     * @return bool
     */
    public function isConfigured(): bool;
}
