<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use OpenAI;

class TestOpenAICommand extends Command
{
    protected $signature = 'test:openai';
    protected $description = 'Test OpenAI client connection';

    public function handle()
    {
        try {
            $client = OpenAI::factory()
                ->withApiKey(config('services.openai.api_key'))
                ->withHttpClient(new \GuzzleHttp\Client([
                    'verify' => false, // Disable SSL verification for development
                    'timeout' => 30,
                ]))
                ->make();
            
            $response = $client->chat()->create([
                'model' => config('services.openai.model', 'gpt-4o-mini'),
                'messages' => [
                    [
                        'role' => 'user',
                        'content' => 'Say "Hello, ReplyPilot is working!"',
                    ],
                ],
                'max_tokens' => 50,
            ]);
            
            $message = $response->choices[0]->message->content;
            
            $this->info('✅ OpenAI client is working correctly!');
            $this->info('Response: ' . $message);
            
        } catch (\Exception $e) {
            $this->error('❌ OpenAI client error: ' . $e->getMessage());
        }
    }
}
