<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;

class ResetAdminPasswordCommand extends Command
{
    protected $signature = 'reset:admin-password {email} {password}';
    protected $description = 'Reset admin user password';

    public function handle()
    {
        $email = $this->argument('email');
        $password = $this->argument('password');
        
        $user = User::where('email', $email)->first();
        
        if (!$user) {
            $this->error("User with email {$email} not found!");
            return 1;
        }
        
        $user->password = bcrypt($password);
        $user->save();
        
        $this->info("Password reset successfully for {$email}");
        $this->line("New password: {$password}");
        
        return 0;
    }
}
