<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;

class CheckAdminUsersCommand extends Command
{
    protected $signature = 'check:admin-users';
    protected $description = 'Check admin users in database';

    public function handle()
    {
        $adminUsers = User::where('role', 'admin')->get(['email', 'name', 'role']);
        
        $this->info('Admin Users:');
        foreach ($adminUsers as $user) {
            $this->line(sprintf(
                'Email: %s | Name: %s | Role: %s',
                $user->email,
                $user->name,
                $user->role
            ));
        }
        
        if ($adminUsers->count() === 0) {
            $this->warn('No admin users found!');
        }
        
        return 0;
    }
}
