# 📚 **ReplyPilot User Manual**

## **Complete Guide to AI-Powered Reply Management**

---

## **Table of Contents**

1. [Getting Started](#getting-started)
2. [How to Login](#how-to-login)
3. [How to Connect Your Google Account](#how-to-connect-your-google-account)
4. [How to Add Email Accounts (SMTP/IMAP)](#how-to-add-email-accounts-smtpimap)
5. [How to Manage Google Business Profile Reviews](#how-to-manage-google-business-profile-reviews)
6. [How to Manage Email Inbox](#how-to-manage-email-inbox)
7. [How to Configure AI Settings](#how-to-configure-ai-settings)
8. [How to Use Email Signatures](#how-to-use-email-signatures)
9. [How to Set Up Automatic Ingestion](#how-to-set-up-automatic-ingestion)
10. [Troubleshooting](#troubleshooting)
11. [Advanced Features](#advanced-features)

---

## **Getting Started**

ReplyPilot is an AI-powered reply assistant that helps you manage Google Business Profile reviews and Gmail emails with human-in-the-loop approval. The system fetches content, generates AI drafts, and requires your approval before posting or sending responses.

**Key Features:**
- 🤖 **Multi-Modal AI**: ChatGPT, Gemini, and Anthropic support
- 📧 **Email Management**: Gmail OAuth + SMTP/IMAP support
- ⭐ **Review Management**: Google Business Profile integration
- 👤 **Human-in-the-Loop**: Always requires approval before posting
- 🔄 **Automatic Ingestion**: Scheduled fetching of new content
- ✍️ **Email Signatures**: Dynamic signature support per account

---

## **How to Login**

**Purpose**: Access your ReplyPilot dashboard to manage reviews and emails with AI assistance.

**End Result**: You'll be logged into your personal ReplyPilot workspace with access to all features.

### **Steps:**

1. **Navigate to ReplyPilot**
   - Go to your ReplyPilot website URL (e.g., `https://your-domain.com`)
   - You'll be automatically redirected to the login page

2. **Enter Your Credentials**
   - Enter your email address in the "Email" field
   - Enter your password in the "Password" field

3. **Click Login**
   - Click the "Log in" button to access your account
   - If credentials are correct, you'll be redirected to the dashboard

4. **Access Dashboard**
   - You'll see the main dashboard with Google Account connection and quick actions
   - Navigation menu includes: Dashboard, Reviews, Inbox, and AI Settings

**Image Space**: *[Screenshot of login page with email/password fields and login button]*

---

## **How to Connect Your Google Account**

**Purpose**: Link your Google account to access Gmail and Google Business Profile for managing reviews and emails.

**End Result**: You'll be able to fetch Gmail emails and Google Business Profile reviews through ReplyPilot.

### **Steps:**

1. **Access the Dashboard**
   - After logging in, you'll see the main dashboard
   - Look for the "Google Account" card on the left side

2. **Click "Connect Google Account"**
   - Click the blue "Connect Google Account" button
   - This will redirect you to Google's OAuth authorization page

3. **Authorize Permissions**
   - Sign in to your Google account if not already signed in
   - Review the permissions requested:
     - Gmail read access
     - Gmail send access
     - Google Business Profile management
   - Click "Allow" to grant permissions

4. **Return to ReplyPilot**
   - You'll be redirected back to ReplyPilot
   - A success message will confirm the connection
   - The Google Account card will show as connected

5. **Verify Connection**
   - Check that the Google Account status shows as connected
   - You can now access Gmail and Google Business Profile features

**Image Space**: *[Screenshot of Google Account card with "Connect Google Account" button]*

**Image Space**: *[Screenshot of Google OAuth permission screen]*

**Image Space**: *[Screenshot of successful connection confirmation]*

---

## **How to Add Email Accounts (SMTP/IMAP)**

**Purpose**: Add additional email accounts (like Hostinger, cPanel, or custom SMTP) to manage emails from multiple providers.

**End Result**: You'll be able to send and receive emails from multiple email accounts through ReplyPilot.

### **Steps:**

1. **Navigate to Email Accounts**
   - Click on "Inbox" in the navigation menu
   - Click on "Email Accounts" or "Manage Accounts" button

2. **Click "Add SMTP Account"**
   - Look for the green "Add SMTP Account" button
   - Click to open the SMTP+IMAP setup form

3. **Fill in Account Details**
   - **Email Address**: Enter your email address
   - **Display Name**: Enter how you want your name to appear
   - **SMTP Settings**:
     - Host: Enter SMTP server (e.g., `smtp.hostinger.com`)
     - Port: Enter port number (usually 587 for TLS or 465 for SSL)
     - Encryption: Select TLS or SSL
     - Username: Your email address
     - Password: Your email password or app password
   - **IMAP Settings** (for receiving emails):
     - Host: Enter IMAP server (e.g., `imap.hostinger.com`)
     - Port: Enter port number (usually 993 for SSL)
     - Encryption: Select SSL
     - Username: Your email address
     - Password: Your email password or app password

4. **Test Connection**
   - Click "Test SMTP Connection" to verify sending works
   - Click "Test IMAP Connection" to verify receiving works
   - Both tests must pass before saving

5. **Save Account**
   - Click "Create Account" to save the configuration
   - You'll see a success message confirming the account was added

6. **Verify Account**
   - The new account will appear in your email accounts list
   - You can now send and receive emails from this account

**Tips for Common Providers**:
  - **For Hostinger:** SMTP: mail.yourdomain.com:587 TLS | IMAP: mail.yourdomain.com:993 SSL
  - **For GoDaddy:** SMTP: smtpout.secureserver.net:465 SSL | IMAP: imap.secureserver.net:993 SSL
  - **For Gmail:** Use SMTP+IMAP with an app password (not your regular password)
  - **For Yahoo:** Use an app password. SMTP: smtp.mail.yahoo.com:465 SSL (or 587 TLS) | IMAP: imap.mail.yahoo.com:993 SSL
  - **For AOL:** Use an app password. SMTP: smtp.aol.com:465 SSL (or 587 TLS) | IMAP: imap.aol.com:993 SSL

**Yahoo/AOL App Password Setup**:
  1. Sign in to your Yahoo/AOL account and open Account Security.
  2. Enable 2-step verification (required to create app passwords).
  3. Create an app password for ReplyPilot.
  4. Use that app password in the SMTP and IMAP password fields.

**Image Space**: *[Screenshot of Email Accounts page with "Add SMTP Account" button]*

**Image Space**: *[Screenshot of SMTP+IMAP setup form with all fields filled]*

**Image Space**: *[Screenshot of successful connection test results]*

---

## **How to Manage Google Business Profile Reviews**

**Purpose**: Fetch, review, and respond to Google Business Profile reviews using AI-generated drafts.

**End Result**: You'll efficiently manage customer reviews with professional, AI-generated responses that you can approve and post.

### **Steps:**

1. **Navigate to Reviews**
   - Click "Reviews" in the navigation menu
   - You'll see the Reviews management page

2. **Add Business Location** (First Time Only)
   - Click "Add Business Location" button
   - Enter your Google Business Profile details:
     - Business Name
     - Google Account ID
     - Location ID
   - Click "Save Location"

3. **Fetch Reviews**
   - Click "Fetch Reviews" or "Ingest Reviews" button
   - The system will fetch recent reviews from Google Business Profile
   - New reviews will appear in the list

4. **Review Customer Feedback**
   - Browse through the list of reviews
   - Each review shows:
     - Customer name and rating
     - Review text
     - Date posted
     - Current status (New, Drafted, Approved, Posted)

5. **Generate AI Draft**
   - Click "AI Draft" button next to any review
   - The AI will analyze the review and generate a professional response
   - The draft will appear in the review details

6. **Review and Edit Draft**
   - Read the AI-generated response
   - Edit if needed using the text editor
   - The draft is automatically saved as you type

7. **Approve Response** (Admin Only)
   - Click "Approve" to approve the draft
   - This marks the response as ready for posting

8. **Post Response** (Admin Only)
   - Click "Post" to publish the response to Google Business Profile
   - The response will appear publicly on your Google Business Profile

**Image Space**: *[Screenshot of Reviews page with list of reviews]*

**Image Space**: *[Screenshot of AI draft generation process]*

**Image Space**: *[Screenshot of review with approved response]*

---

## **How to Manage Email Inbox**

**Purpose**: Fetch, review, and respond to emails using AI-generated drafts with human approval.

**End Result**: You'll efficiently manage email communications with professional, AI-generated responses.

### **Steps:**

1. **Navigate to Inbox**
   - Click "Inbox" in the navigation menu
   - You'll see the Email Inbox page

2. **Fetch Emails**
   - Click "Fetch Emails" or "Ingest Inbox" button
   - The system will fetch recent emails from your connected accounts
   - New email threads will appear in the list

3. **Browse Email Threads**
   - View the list of email conversations
   - Each thread shows:
     - Subject line
     - Sender information
     - Latest message preview
     - Thread status (New, Drafted, Approved, Sent)

4. **Open Email Thread**
   - Click on any email thread to view the full conversation
   - You'll see the complete email history

5. **Generate AI Draft**
   - Click "AI Draft" button to generate a response
   - The AI will analyze the email thread and generate a contextual reply
   - The draft will appear in the editor

6. **Edit Draft Response**
   - Review the AI-generated response
   - Use the rich text editor to make changes
   - Add formatting, links, or modify the content as needed

7. **Save Draft**
   - Click "Save Changes" to save your edits
   - The draft is automatically saved and can be edited later

8. **Approve and Send** (Admin Only)
   - Click "Send Email" to approve and send the response
   - The email will be sent through your configured email account
   - The thread status will update to "Sent"

**Image Space**: *[Screenshot of Email Inbox with list of threads]*

**Image Space**: *[Screenshot of email thread with AI draft]*

**Image Space**: *[Screenshot of email editor with rich text formatting]*

---

## **How to Configure AI Settings**

**Purpose**: Configure which AI provider to use and manage AI settings for optimal performance.

**End Result**: You'll have full control over which AI service generates your responses and can optimize performance.

### **Steps:**

1. **Navigate to AI Settings**
   - Click "AI Settings" in the navigation menu
   - You'll see the AI configuration page

2. **Select Default AI Provider**
   - Choose from available providers:
     - **Gemini** (Default - Google's AI)
     - **ChatGPT** (OpenAI)
     - **Anthropic** (Claude)
   - Click the radio button next to your preferred provider

3. **Configure Provider Settings**
   - **Gemini**: Uses Google's Gemini API
   - **ChatGPT**: Requires OpenAI API key
   - **Anthropic**: Requires Anthropic API key
   - Ensure your API keys are configured in the system

4. **Test AI Connection**
   - Click "Test Connection" for each provider
   - Verify that the AI service is working correctly
   - You'll see success/error messages for each test

5. **Save Settings**
   - Click "Save Settings" to apply your changes
   - The new AI provider will be used for all future drafts

6. **Monitor Performance**
   - Check the AI performance metrics
   - Review response quality and adjust settings as needed

**Image Space**: *[Screenshot of AI Settings page with provider selection]*

**Image Space**: *[Screenshot of AI connection test results]*

---

## **How to Use Email Signatures**

**Purpose**: Create and manage professional email signatures for different email accounts.

**End Result**: You'll have personalized, professional signatures automatically added to your email responses.

### **Steps:**

1. **Navigate to Email Accounts**
   - Go to Inbox → Email Accounts
   - Find the email account you want to add signatures to

2. **Click "Signatures" Button**
   - Click the "Signatures" button next to your email account
   - You'll see the signature management page

3. **Add New Signature**
   - Click "Add Signature" button
   - Fill in the signature details:
     - **Signature Name**: Give it a descriptive name
     - **Signature Content**: Enter your signature text/HTML
     - **Set as Default**: Check if this should be the default signature

4. **Format Your Signature**
   - Use the rich text editor to format your signature
   - Add:
     - Your name and title
     - Company information
     - Contact details
     - Social media links
     - Professional disclaimers

5. **Save Signature**
   - Click "Save Signature" to save your work
   - The signature will be available for use

6. **Set Default Signature**
   - Click "Set as Default" to make this signature the default
   - Only one signature can be default per account

7. **Use in Emails**
   - When composing emails, your default signature will be automatically added
   - You can select different signatures if you have multiple

**Image Space**: *[Screenshot of signature management page]*

**Image Space**: *[Screenshot of signature editor with formatted content]*

---

## **How to Set Up Automatic Ingestion**

**Purpose**: Configure automatic fetching of new emails and reviews so you don't have to manually check for new content.

**End Result**: The system will automatically fetch new content every 15 minutes (emails) and every hour (reviews) without manual intervention.

### **Steps:**

1. **Access System Settings**
   - Contact your system administrator to configure automatic ingestion
   - This requires server-level configuration

2. **Start the Scheduler**
   - Run: `php artisan schedule:work` (keeps running)
   - Or run: `php artisan schedule:run` (one-time execution)

3. **Start the Queue Worker**
   - Run: `php artisan queue:work` to process background jobs
   - This handles the actual ingestion tasks

4. **Verify Automatic Ingestion**
   - Check the logs to see automatic ingestion working
   - New emails and reviews should appear automatically
   - No manual "Fetch" buttons needed

5. **Monitor Performance**
   - Use `php artisan schedule:status` to check scheduler status
   - Monitor queue processing with `php artisan queue:monitor`

**Image Space**: *[Screenshot of automatic ingestion working in logs]*

**Image Space**: *[Screenshot of schedule status command output]*

---

## **Troubleshooting**

### **Common Issues and Solutions**

#### **Login Problems**
- **Issue**: Can't log in with correct credentials
- **Solution**: 
  1. Verify email and password are correct
  2. Check if account is locked
  3. Contact administrator to reset password

#### **Google Account Connection Issues**
- **Issue**: Google OAuth not working
- **Solution**:
  1. Check if Google OAuth is configured in system
  2. Verify Google Cloud Console settings
  3. Ensure redirect URI is correct

#### **Email Account Connection Problems**
- **Issue**: SMTP/IMAP connection fails
- **Solution**:
  1. Verify email credentials are correct
  2. Check if app passwords are needed (for 2FA accounts)
  3. Verify server settings (host, port, encryption)
  4. Test connection before saving

#### **AI Draft Generation Issues**
- **Issue**: AI not generating drafts
- **Solution**:
  1. Check AI provider settings
  2. Verify API keys are configured
  3. Test AI connection in settings
  4. Check if AI service is available

#### **Email Sending Problems**
- **Issue**: Emails not sending
- **Solution**:
  1. Check SMTP configuration
  2. Verify email account is active
  3. Check for authentication errors
  4. Test SMTP connection

---

## **Advanced Features**

### **Multi-Modal AI Support**
- Switch between ChatGPT, Gemini, and Anthropic
- Each AI has different strengths and response styles
- Configure which AI to use for different types of content

### **Email Threading**
- Automatic email thread management
- Proper In-Reply-To headers for conversation continuity
- Thread status tracking (New, Drafted, Approved, Sent)

### **Review Management**
- Bulk review processing
- Review status tracking
- Escalation for sensitive content

### **Security Features**
- CSRF protection on all forms
- Input validation and sanitization
- Secure credential storage
- Audit logging for all actions

### **Performance Optimization**
- Background job processing
- Automatic cleanup of old data
- Database optimization
- Caching for improved performance

---

## **Support and Help**

### **Getting Help**
- Check this manual for common issues
- Review the troubleshooting section
- Contact your system administrator
- Check application logs for error details

### **System Requirements**
- Modern web browser (Chrome, Firefox, Safari, Edge)
- Stable internet connection
- JavaScript enabled
- Cookies enabled

### **Best Practices**
- Regularly review and approve AI drafts
- Keep email signatures professional
- Monitor automatic ingestion status
- Keep AI settings optimized for your needs
- Regularly check for system updates

---

**🎉 Congratulations! You're now ready to use ReplyPilot effectively for managing your reviews and emails with AI assistance!**
