# Google Business Profile Integration - User Guide

This guide explains how to connect your Google Business Profile to ReplyPilot and start managing your customer reviews with AI-powered responses.

## 📋 Table of Contents

- [Overview](#overview)
- [Prerequisites](#prerequisites)
- [Quick Setup Guide](#quick-setup-guide)
- [Step-by-Step Instructions](#step-by-step-instructions)
- [Managing Your Reviews](#managing-your-reviews)
- [Troubleshooting](#troubleshooting)
- [FAQ](#faq)

## 🎯 Overview

ReplyPilot's Google Business Profile integration allows you to:

- ✅ **Connect your Google Business Profile** with just a few clicks
- ✅ **Import your business locations** automatically
- ✅ **Fetch all your customer reviews** in real-time
- ✅ **Generate AI-powered responses** to reviews
- ✅ **Post approved responses** back to Google
- ✅ **Manage multiple business locations** from one dashboard

## 📋 Prerequisites

Before you start, make sure you have:

- [ ] **Active Google Business Profile** with at least one location
- [ ] **Admin access** to your Google Business Profile
- [ ] **Customer reviews** on your Google Business Profile
- [ ] **ReplyPilot account** with proper permissions

## 🚀 Quick Setup Guide

Setting up Google Business Profile integration takes just **3 simple steps**:

1. **Connect** your Google account
2. **Import** your business locations  
3. **Fetch** your customer reviews

**Total time**: Less than 5 minutes!

## 📖 Step-by-Step Instructions

### Step 1: Connect Your Google Account

1. **Log into ReplyPilot**
   - Go to your ReplyPilot dashboard
   - Navigate to the **Reviews** section

2. **Start Google Business Profile Setup**
   - Click the **"Connect Google Business Profile"** button
   - You'll be redirected to Google's OAuth consent screen

3. **Authorize ReplyPilot**
   - Sign in with your Google account (the one linked to your business)
   - Review the permissions requested by ReplyPilot
   - Click **"Allow"** to grant access

4. **Confirmation**
   - You'll be redirected back to ReplyPilot
   - You should see a success message confirming the connection

### Step 2: Import Your Business Locations

1. **Access Reviews Management**
   - Go to the **Reviews Management** page
   - You should see your connected Google account

2. **Import Locations**
   - Click the **"Import Locations"** button
   - ReplyPilot will fetch all your Google Business Profile locations
   - You'll see a success message showing how many locations were imported

3. **Verify Locations**
   - Check that all your business locations appear correctly
   - Each location should show the correct name and address

### Step 3: Fetch Your Customer Reviews

1. **Fetch Reviews**
   - Click the **"Fetch Reviews"** button
   - ReplyPilot will retrieve all reviews from your business locations
   - This may take a few moments depending on the number of reviews

2. **Review Import Results**
   - You'll see a success message showing how many reviews were imported
   - All your customer reviews will now appear in the ReplyPilot dashboard

## 📊 Managing Your Reviews

### Viewing Reviews

Once imported, you can:

- **Browse all reviews** in chronological order
- **Filter by star rating** (1-5 stars)
- **Search reviews** by customer name or content
- **View review details** including date, rating, and full text

### Generating AI Responses

1. **Select a Review**
   - Click on any review you want to respond to
   - Click the **"AI Draft"** button

2. **Review AI Response**
   - ReplyPilot will generate a professional response
   - Review the suggested response carefully
   - Edit if needed using the built-in editor

3. **Approve and Send**
   - Click **"Approve & Send"** to post the response
   - The response will appear on your Google Business Profile
   - The review status will update to "Posted"

### Managing Multiple Locations

If you have multiple business locations:

- **All locations** are imported automatically
- **Reviews from all locations** appear in one dashboard
- **Location information** is clearly displayed with each review
- **Filter by location** if needed

## 🐛 Troubleshooting

### Common Issues

#### "No Google Business Profile locations found"
**Possible causes:**
- Your Google account isn't properly connected
- You don't have admin access to the Google Business Profile
- The business profile hasn't been set up yet

**Solutions:**
1. Reconnect your Google account
2. Verify you have admin access to your Google Business Profile
3. Set up your Google Business Profile first

#### "Failed to fetch reviews"
**Possible causes:**
- Temporary API issue
- Network connectivity problem
- Google account permissions expired

**Solutions:**
1. Wait a few minutes and try again
2. Check your internet connection
3. Reconnect your Google account if needed

#### "No reviews found"
**Possible causes:**
- Your business doesn't have any reviews yet
- Reviews are on a different Google Business Profile
- Location mismatch

**Solutions:**
1. Verify reviews exist on your Google Business Profile
2. Check that you're using the correct Google account
3. Ensure your business locations are properly set up

### Getting Help

If you encounter issues:

1. **Check the error message** for specific details
2. **Try reconnecting** your Google account
3. **Contact support** with the error details
4. **Verify your Google Business Profile** is properly set up

## ❓ FAQ

### Q: Do I need to set up Google APIs myself?
**A:** No! ReplyPilot has already set up all the necessary Google APIs and permissions. You just need to connect your Google account.

### Q: Can I connect multiple Google accounts?
**A:** Currently, you can connect one Google account per ReplyPilot account. If you have multiple businesses, you may need separate ReplyPilot accounts.

### Q: How often are reviews updated?
**A:** Reviews are fetched when you click "Fetch Reviews". For automatic updates, contact support about setting up scheduled sync.

### Q: Can I edit AI-generated responses?
**A:** Yes! You can edit any AI-generated response before posting it to Google.

### Q: What happens if I disconnect my Google account?
**A:** Your imported reviews will remain in ReplyPilot, but you won't be able to fetch new reviews or post responses until you reconnect.

### Q: Is my data secure?
**A:** Yes! ReplyPilot uses secure OAuth authentication and follows Google's security guidelines. Your data is encrypted and protected.

### Q: Can I respond to reviews from multiple locations?
**A:** Yes! If you have multiple business locations, all reviews appear in one dashboard and you can respond to any of them.

### Q: What if I don't like an AI response?
**A:** You can edit the response, regenerate a new one, or write your own custom response.

## 🔒 Security & Privacy

### Data Protection
- **OAuth Authentication**: Secure connection to Google
- **Encrypted Storage**: All data is encrypted at rest
- **Access Control**: Only you can access your review data
- **No Data Sharing**: Your data is never shared with other users

### Permissions
ReplyPilot requests these permissions from Google:
- **Business Management**: To read and manage your business profile
- **Review Access**: To read your customer reviews
- **Response Posting**: To post responses to reviews

## 📞 Support

### Need Help?

If you need assistance:

1. **Check this guide** for common solutions
2. **Contact support** with specific error messages
3. **Include screenshots** of any issues you encounter
4. **Provide your Google Business Profile URL** for faster troubleshooting

### Contact Information

- **Email**: support@replypilot.com
- **Documentation**: [ReplyPilot Help Center](https://help.replypilot.com)
- **Status Page**: [status.replypilot.com](https://status.replypilot.com)

---

**Congratulations!** You're now ready to manage your Google Business Profile reviews with AI-powered responses. Start by connecting your Google account and importing your reviews to get started! 🚀
