# Changelog

All notable changes to ReplyPilot will be documented in this file.

## [Unreleased]

### Added - 2025-11-22

#### Mobile Responsive Design
Complete mobile optimization for all main application pages.

**Files Updated:**
- `resources/views/super-admin/email/index.blade.php`
- `resources/views/tenant-admin/email/index.blade.php`
- `resources/views/agent/email/index.blade.php`
- `resources/views/super-admin/reviews/index.blade.php`
- `resources/views/tenant-admin/reviews/index.blade.php`
- `resources/views/agent/reviews/index.blade.php`
- `resources/views/dashboard.blade.php`
- `resources/views/super-admin/settings/index.blade.php`
- `resources/views/tenant-admin/settings/index.blade.php`
- `resources/views/layouts/navigation.blade.php`

**Changes Applied:**
- Mobile hamburger menus with JavaScript toggle functionality
- Responsive navigation (hidden on mobile, visible on desktop)
- Icon-only buttons on mobile screens (`hidden sm:inline` pattern)
- Stacked layouts on small screens (`flex-col sm:flex-row`)
- Responsive text sizing (`text-2xl sm:text-3xl`)
- Smaller button padding on mobile (`py-2 px-3 sm:py-2 sm:px-4`)
- CSS fixes for link underlining and list bullet removal
- Converted Alpine.js to plain JavaScript in navigation layout

**Mobile Menu JavaScript Pattern:**
```javascript
function toggleMobileMenu() {
    const menu = document.getElementById('mobile-menu');
    const menuIcon = document.getElementById('menu-icon');
    const closeIcon = document.getElementById('close-icon');

    menu.classList.toggle('hidden');
    menuIcon.classList.toggle('hidden');
    menuIcon.classList.toggle('block');
    closeIcon.classList.toggle('hidden');
    closeIcon.classList.toggle('block');
}
```

### Fixed - 2025-11-22

#### Security Audit Fixes
- Fixed SSL verification issues
- Added CSRF protection to all forms
- Fixed database migration issues
- Added proper form request validation

#### UI Fixes
- Fixed black dots issue (broken tracking pixel images)
- Fixed IMAP timeout errors with increased timeout settings
