# 🔄 Automatic Ingestion System - ReplyPilot

## **OVERVIEW**

Your ReplyPilot application now has **automatic periodic ingestion** for both emails and reviews! The system runs in the background and automatically fetches new content at regular intervals.

---

## 📅 **SCHEDULED TASKS**

### **✅ Email Auto-Ingestion**
- **Frequency**: Every 15 minutes
- **Command**: `email:auto-ingest`
- **Description**: Automatically ingests emails from all configured accounts
- **Status**: ✅ **ACTIVE**

### **✅ Review Auto-Ingestion**
- **Frequency**: Every hour
- **Command**: `reviews:auto-ingest`
- **Description**: Automatically ingests reviews from all configured locations
- **Status**: ✅ **ACTIVE**

### **✅ Email Cleanup**
- **Frequency**: Daily at 2:00 AM
- **Command**: `email:cleanup-old`
- **Description**: Cleans up old ingested emails
- **Status**: ✅ **ACTIVE**

---

## 🚀 **HOW IT WORKS**

### **Email Ingestion Process**
1. **Every 15 minutes**, the system checks all email accounts
2. **OAuth Accounts**: Fetches new emails via Gmail API
3. **SMTP+IMAP Accounts**: Fetches new emails via IMAP
4. **Background Processing**: All ingestion runs in background jobs
5. **Automatic Retry**: Failed jobs retry with exponential backoff

### **Review Ingestion Process**
1. **Every hour**, the system checks all configured locations
2. **Google Business Profile**: Fetches new reviews via Google API
3. **Background Processing**: All ingestion runs in background jobs
4. **Automatic Retry**: Failed jobs retry with exponential backoff

---

## 🛠️ **SETUP & MANAGEMENT**

### **1. Start the Scheduler**
```bash
# Start Laravel scheduler (keeps running)
php artisan schedule:work

# Or run once (for testing)
php artisan schedule:run
```

### **2. Start the Queue Worker**
```bash
# Start queue worker (processes background jobs)
php artisan queue:work

# Or run in background
php artisan queue:work --daemon
```

### **3. Check System Status**
```bash
# View all scheduled tasks
php artisan schedule:status

# List scheduled tasks
php artisan schedule:list

# Check queue status
php artisan queue:monitor
```

---

## 🧪 **TESTING COMMANDS**

### **Test Email Ingestion**
```bash
# Test all email accounts
php artisan email:auto-ingest

# Test specific account
php artisan email:auto-ingest --account=123

# Test specific type
php artisan email:auto-ingest --type=imap
php artisan email:auto-ingest --type=oauth
```

### **Test Review Ingestion**
```bash
# Test all locations
php artisan reviews:auto-ingest

# Test specific location
php artisan reviews:auto-ingest --business=456
```

### **Test Email Cleanup**
```bash
# Test cleanup (1 hour retention)
php artisan email:cleanup-old --retention=1
```

---

## 📊 **MONITORING & LOGS**

### **View Ingestion Logs**
```bash
# Real-time logs
tail -f storage/logs/laravel.log | grep "Auto.*ingestion"

# Email ingestion logs
tail -f storage/logs/laravel.log | grep "email.*ingestion"

# Review ingestion logs
tail -f storage/logs/laravel.log | grep "review.*ingestion"
```

### **Check Queue Status**
```bash
# View queue jobs
php artisan queue:work --once

# Monitor queue
php artisan queue:monitor

# Clear failed jobs
php artisan queue:flush
```

---

## ⚙️ **CONFIGURATION**

### **Email Accounts Setup**
1. **OAuth Accounts**: Connect via Google OAuth
2. **SMTP+IMAP Accounts**: Configure via setup form
3. **Both types** are automatically processed

### **Review Locations Setup**
1. **Add Location**: Configure Google Business Profile
2. **Set Location ID**: Ensure `location_id` is set
3. **Active Status**: Location must be active

### **Scheduling Configuration**
- **Email Frequency**: Every 15 minutes (configurable)
- **Review Frequency**: Every hour (configurable)
- **Cleanup Frequency**: Daily at 2:00 AM (configurable)

---

## 🔧 **CUSTOMIZATION**

### **Change Ingestion Frequency**
Edit `routes/console.php`:

```php
// Email ingestion - change from every 15 minutes
Schedule::command('email:auto-ingest')
    ->everyFiveMinutes()  // Every 5 minutes
    ->name('email-auto-ingest');

// Review ingestion - change from hourly
Schedule::command('reviews:auto-ingest')
    ->everyThirtyMinutes()  // Every 30 minutes
    ->name('reviews-auto-ingest');
```

### **Add Custom Schedules**
```php
// Custom email ingestion for specific accounts
Schedule::command('email:auto-ingest --account=123')
    ->hourly()
    ->name('email-specific-account');

// Custom review ingestion for specific location
Schedule::command('reviews:auto-ingest --business=456')
    ->daily()
    ->name('reviews-specific-location');
```

---

## 🚨 **TROUBLESHOOTING**

### **Scheduler Not Running**
```bash
# Check if scheduler is working
php artisan schedule:list

# Test scheduler
php artisan schedule:run

# Start scheduler
php artisan schedule:work
```

### **Queue Not Processing**
```bash
# Check queue status
php artisan queue:monitor

# Start queue worker
php artisan queue:work

# Clear failed jobs
php artisan queue:flush
```

### **No Emails/Reviews Being Fetched**
1. **Check Account Configuration**: Ensure accounts are properly set up
2. **Check API Keys**: Verify Google OAuth and API keys
3. **Check Logs**: Look for error messages in logs
4. **Test Manually**: Run ingestion commands manually

### **High Server Load**
1. **Reduce Frequency**: Change from 15 minutes to 30 minutes
2. **Limit Accounts**: Process specific accounts only
3. **Add Delays**: Add delays between account processing

---

## 📈 **PERFORMANCE METRICS**

### **Expected Performance**
- **Email Ingestion**: 5-10 accounts per minute
- **Review Ingestion**: 1-5 locations per minute
- **Memory Usage**: 50-100MB per job
- **Database Impact**: Minimal (background processing)

### **Monitoring Commands**
```bash
# Check system performance
php artisan schedule:status --test

# Monitor queue performance
php artisan queue:monitor

# Check database performance
php artisan production:optimize --optimize-db
```

---

## 🔒 **SECURITY CONSIDERATIONS**

### **API Rate Limits**
- **Gmail API**: 1,000,000 requests per day
- **Google Business Profile**: 100,000 requests per day
- **Automatic Throttling**: Built-in rate limiting

### **Data Privacy**
- **Secure Storage**: All credentials encrypted
- **Access Logs**: All access attempts logged
- **Audit Trail**: Complete ingestion history

---

## 📋 **MAINTENANCE**

### **Daily Tasks**
- ✅ Monitor ingestion logs
- ✅ Check queue status
- ✅ Verify new content is being fetched

### **Weekly Tasks**
- ✅ Review performance metrics
- ✅ Check for failed jobs
- ✅ Update API credentials if needed

### **Monthly Tasks**
- ✅ Analyze ingestion patterns
- ✅ Optimize scheduling frequency
- ✅ Review and clean old data

---

## ✅ **CURRENT STATUS**

| Feature | Status | Frequency | Last Run |
|---------|--------|-----------|----------|
| **Email Auto-Ingestion** | ✅ Active | Every 15 min | Running |
| **Review Auto-Ingestion** | ✅ Active | Every hour | Running |
| **Email Cleanup** | ✅ Active | Daily 2 AM | Running |
| **Queue Processing** | ⚠️ Manual | Continuous | Start required |
| **Scheduler** | ⚠️ Manual | Continuous | Start required |

---

## 🚀 **NEXT STEPS**

1. **Start the Scheduler**: `php artisan schedule:work`
2. **Start the Queue**: `php artisan queue:work`
3. **Monitor Logs**: Check ingestion activity
4. **Configure Locations**: Add review locations
5. **Test System**: Run test commands

**Your ReplyPilot application now has fully automated email and review ingestion!** 🎉
